#include "touch.h"
#include "save_cm_cp.h"

#ifdef UNITTEST
#include <stdio.h>
#endif

#ifndef EOK
#define EOK 0
#endif

int
save_cm_file(char *p_file, cypress_dev_t* cypress, uint32_t **Cm_matrix)
{
    FILE *fp = NULL;
    int i = 0, j = 0;

    fp = fopen (p_file, "w");
    if (NULL == fp) {
        return -1;
    }

    for (i = 0; i < cypress->register_map.pcfg_data.electrodes_y; i++) {
        for (j = 0; j < cypress->register_map.pcfg_data.electrodes_x; j++) {
            fprintf(fp, "%d\n", Cm_matrix[j][i]);
        }
    }
    fclose (fp);

    return EOK;
}

int
save_cp_file(char *p_file, cypress_dev_t* cypress, uint32_t *Cp_tx_selfcap, uint32_t *Cp_tx_selfcap_cal, uint32_t *Cp_rx_selfcap, uint32_t *Cp_rx_selfcap_cal)
{
    FILE *fp = NULL;
    int i = 0;

    fp = fopen (p_file, "w");
    if (NULL == fp) {
        return -1;
    }

    for (i = 0; i < cypress->register_map.pcfg_data.electrodes_y; i++) {
        fprintf(fp, "%d\n", Cp_tx_selfcap[i]);
    }

    for (i = 0; i < cypress->register_map.pcfg_data.electrodes_x; i++) {
        fprintf(fp, "%d\n", Cp_rx_selfcap[i]);
    }

    fclose (fp);

    return EOK;
}

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/branches/7.0.0/trunk/hardware/mtouch/cypress/save_cm_cp.c $ $Rev: 889164 $")
#endif
